/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.viewers.media;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyXRef;
import genj.io.InputSource;
import genj.renderer.MediaRenderer;
import genj.renderer.MediaUtils;
import org.openide.util.Exceptions;

public class MediaWrapper {
    private boolean recordType = true;
    private Property hostingProperty = null;
    private Entity targetMedia = null;
    private InputSource newInputSource = null;
    private InputSource oldInputSource = null;
    private String fileTitle = "";
    private String mediaTitle = "";

    public MediaWrapper(Property propertyObje) {
        if (propertyObje instanceof PropertyMedia) {
            this.targetMedia = ((PropertyMedia)propertyObje).getTargetEntity().orElse(null);
            this.hostingProperty = propertyObje;
            this.setInfoFromRead((Property)this.targetMedia, true);
        } else if (propertyObje instanceof Media) {
            this.targetMedia = (Media)propertyObje;
            this.hostingProperty = null;
            this.setInfoFromRead((Property)this.targetMedia, true);
        } else {
            this.hostingProperty = propertyObje;
            this.setInfoFromRead(propertyObje, false);
        }
        this.oldInputSource = this.newInputSource;
    }

    public MediaWrapper(String title) {
        this.setTitle(title);
    }

    public MediaWrapper(InputSource f, String title) {
        this.recordType = false;
        this.setInputSource(f);
        this.setTitle(title);
    }

    public MediaWrapper(InputSource is) {
        this.setInputSource(is);
    }

    private void setInfoFromRead(Property property, boolean recordType) {
        Property mediaTitleProperty;
        this.recordType = recordType;
        if (property == null) {
            return;
        }
        Property fileTitleProp = null;
        Property mediaFile = property.getProperty("FILE", false);
        if (mediaFile != null && mediaFile instanceof PropertyFile) {
            this.newInputSource = MediaRenderer.getSource((Property)mediaFile);
            if (recordType) {
                fileTitleProp = mediaFile.getProperty("TITL");
            }
        }
        if (!recordType) {
            fileTitleProp = property.getProperty("TITL");
        }
        if (property.isGrammar7() && (mediaTitleProperty = property.getProperty("TITL")) != null) {
            this.mediaTitle = mediaTitleProperty.getDisplayValue();
        }
        if (fileTitleProp != null) {
            this.fileTitle = fileTitleProp.getDisplayValue();
        }
    }

    public void setTargetEntity(Media entity) {
        this.targetMedia = entity;
        this.setInfoFromRead((Property)this.targetMedia, true);
    }

    public void setHostingProperty(Property property) {
        this.hostingProperty = property;
    }

    public void setInputSource(InputSource is) {
        this.newInputSource = is;
    }

    public void setTitle(String str) {
        this.fileTitle = str;
    }

    public Property getHostingProperty() {
        return this.hostingProperty;
    }

    public InputSource getInputSource() {
        return this.newInputSource;
    }

    public String getTitle() {
        return this.fileTitle;
    }

    public Entity getTargetMedia() {
        return this.targetMedia;
    }

    public boolean getRecordType() {
        return this.recordType;
    }

    public void update(Property mainProp) {
        if (this.hostingProperty == null) {
            if (this.fileTitle.isEmpty() && this.targetMedia == null && this.oldInputSource == null && this.newInputSource == null) {
                return;
            }
            Gedcom gedcom = mainProp.getGedcom();
            if (gedcom.getGrammar().equals(Grammar.V55)) {
                this.hostingProperty = mainProp.addProperty("OBJE", "");
                this.putMediaCitation(this.hostingProperty);
            } else {
                try {
                    Property p;
                    if (this.targetMedia == null) {
                        this.targetMedia = mainProp.getGedcom().createEntity("OBJE");
                    }
                    int posTo = (p = mainProp.getProperty("OBJE")) == null ? 0 : mainProp.getPropertyPosition(p) + 1;
                    this.hostingProperty = mainProp.addMedia((Media)this.targetMedia);
                    int posFrom = mainProp.getPropertyPosition(this.hostingProperty);
                    if (posFrom < posTo) {
                        this.hostingProperty.getParent().moveProperty(this.hostingProperty, posTo);
                    }
                    this.putMediaRecord((Property)((Media)this.targetMedia));
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else if (!this.recordType) {
            this.putMediaCitation(this.hostingProperty);
        } else if (this.recordType && this.hostingProperty instanceof PropertyMedia) {
            this.putMediaRecord((Property)this.targetMedia);
            PropertyMedia pm = (PropertyMedia)this.hostingProperty;
            Media tme = pm.getTargetEntity().orElse(null);
            if (!this.targetMedia.equals(tme)) {
                MediaUtils.replaceRef((PropertyXRef)pm, (Entity)tme, (Entity)this.targetMedia);
            }
        } else if (this.recordType && !(this.hostingProperty instanceof PropertyMedia)) {
            this.hostingProperty.getParent().delProperty(this.hostingProperty);
            Property p = mainProp.getProperty("OBJE");
            int posTo = p == null ? 0 : mainProp.getPropertyPosition(p) + 1;
            this.hostingProperty = mainProp.addMedia((Media)this.targetMedia);
            int posFrom = mainProp.getPropertyPosition(this.hostingProperty);
            if (posFrom < posTo) {
                this.hostingProperty.getParent().moveProperty(this.hostingProperty, posTo);
            }
            this.putMediaRecord((Property)this.targetMedia);
        }
    }

    public void reposition(int index) {
        if (this.hostingProperty != null && this.hostingProperty.getParent() != null) {
            Property p = this.hostingProperty.getParent().getProperty("OBJE");
            int startingPos = this.hostingProperty.getParent().getPropertyPosition(p);
            int currentPos = this.hostingProperty.getParent().getPropertyPosition(this.hostingProperty);
            if (currentPos != startingPos + index) {
                this.hostingProperty.getParent().moveProperty(this.hostingProperty, startingPos + index);
            }
        }
    }

    private void putMediaRecord(Property property) {
        Property mediaTitle;
        Property mediaForm;
        String extension = "";
        Property mediaFile = property.getProperty("FILE", false);
        if (mediaFile == null) {
            mediaFile = property.addProperty("FILE", "");
        }
        if (this.newInputSource != null) {
            extension = this.newInputSource.getExtension();
            if (extension == null) {
                extension = "";
            }
            if (!this.newInputSource.equals(this.oldInputSource)) {
                ((PropertyFile)mediaFile).addFile(this.newInputSource);
            }
        } else {
            mediaForm = mediaFile.getProperty("FORM");
            if (mediaForm != null) {
                extension = mediaForm.getValue();
            }
        }
        if ((mediaForm = mediaFile.getProperty("FORM")) == null) {
            mediaForm = mediaFile.addProperty("FORM", "");
        }
        if (mediaForm != null) {
            MediaUtils.setDistinctValue((Property)mediaForm, (String)(mediaForm.isGrammar7() ? PropertyFile.getMimeType((String)extension) : extension));
        }
        if ((mediaTitle = mediaFile.getProperty("TITL")) == null) {
            mediaTitle = mediaFile.addProperty("TITL", "");
        }
        if (mediaTitle != null) {
            MediaUtils.setDistinctValue((Property)mediaTitle, (String)this.fileTitle);
        }
    }

    private void putMediaCitation(Property property) {
        if (this.newInputSource != null && !this.newInputSource.equals(this.oldInputSource)) {
            Grammar grammar;
            String extension = "";
            Property mediaFile = property.getProperty("FILE", false);
            if (mediaFile == null) {
                mediaFile = property.addProperty("FILE", "");
            }
            if (this.newInputSource != null) {
                extension = this.newInputSource.getExtension();
                if (extension == null) {
                    extension = "";
                }
                ((PropertyFile)mediaFile).addFile(this.newInputSource);
            }
            if ((grammar = property.getGedcom().getGrammar()).equals(Grammar.V55)) {
                Property pForm = property.getProperty("FORM");
                if (pForm == null) {
                    pForm = property.addProperty("FORM", "");
                }
                if (pForm != null) {
                    MediaUtils.setDistinctValue((Property)pForm, (String)extension);
                }
            } else {
                Property pForm = mediaFile.getProperty("FORM");
                if (pForm == null) {
                    pForm = mediaFile.addProperty("FORM", "");
                }
                if (pForm != null) {
                    MediaUtils.setDistinctValue((Property)pForm, (String)(property.isGrammar7() ? PropertyFile.getMimeType((String)extension) : extension));
                }
            }
        }
        String oldTitle = "";
        String newTitle = this.fileTitle;
        Property titlProp = property.getProperty("TITL");
        if (titlProp != null) {
            oldTitle = titlProp.getValue();
        }
        if (!newTitle.equals(oldTitle)) {
            if (titlProp == null && !newTitle.isEmpty()) {
                titlProp = property.addProperty("TITL", "");
                titlProp.setValue(newTitle);
            } else if (!oldTitle.isEmpty() && newTitle.isEmpty()) {
                property.delProperty(titlProp);
            } else {
                MediaUtils.setDistinctValue((Property)titlProp, (String)newTitle);
            }
        }
    }

    public void remove() {
        if (this.hostingProperty == null) {
            return;
        }
        this.hostingProperty.getParent().delProperty(this.hostingProperty);
    }
}

