/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.editor;

import ancestris.modules.releve.MainPanelInterface;
import ancestris.modules.releve.RelevePlaceEditor;
import ancestris.modules.releve.editor.Bean;
import ancestris.modules.releve.editor.BeanAge;
import ancestris.modules.releve.editor.BeanDate;
import ancestris.modules.releve.editor.BeanDead;
import ancestris.modules.releve.editor.BeanEventTag;
import ancestris.modules.releve.editor.BeanEventType;
import ancestris.modules.releve.editor.BeanFirstName;
import ancestris.modules.releve.editor.BeanFreeComment;
import ancestris.modules.releve.editor.BeanLastName;
import ancestris.modules.releve.editor.BeanMedia;
import ancestris.modules.releve.editor.BeanNotary;
import ancestris.modules.releve.editor.BeanOccupation;
import ancestris.modules.releve.editor.BeanPlace;
import ancestris.modules.releve.editor.BeanSex;
import ancestris.modules.releve.editor.BeanSimpleValue;
import ancestris.modules.releve.editor.BeanText;
import ancestris.modules.releve.editor.EditorBeanGroup;
import ancestris.modules.releve.editor.EditorConfigGroupDialog;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.BeanField;
import ancestris.modules.releve.model.BeanGroup;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.FieldSex;
import ancestris.modules.releve.model.RecordInfoPlace;
import ancestris.modules.releve.model.RecordModel;
import ancestris.util.swing.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;

public class ReleveEditor
extends JPanel
implements FocusListener,
EditorConfigGroupDialog.EditorConfigListener {
    private DataManager dataManager = null;
    private RecordModel recordModel = null;
    private Bean currentFocusedBean = null;
    private AbstractRecord currentRecord = null;
    private final ArrayList<KeyStroke> recordKeyStrokeList = new ArrayList();
    private MainPanelInterface transcriber;
    private JPanel fieldsPanel;
    private JButton jButtonPlace;
    private JLabel jLabelPlace;
    private JPanel jPanel1;
    private JPanel jPanelPlace;
    private JScrollPane jScrollPane1;

    public ReleveEditor() {
        this.initComponents();
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(20);
        this.jScrollPane1.getActionMap().remove(KeyStroke.getKeyStroke(38, 512));
        this.jScrollPane1.getActionMap().remove(KeyStroke.getKeyStroke(40, 512));
        String shortCut = "EditorShortcut";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(88, 512), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt Y"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt A"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt B"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke("alt H"), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(61, 512), shortCut);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(521, 512), shortCut);
        this.getActionMap().put(shortCut, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().toUpperCase().equals("X")) {
                    ReleveEditor.this.copyIndiNameToIndiFatherName();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("Y")) {
                    ReleveEditor.this.copyWifeNameToWifeFatherName();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("A")) {
                    ReleveEditor.this.giveFocusToIndiAge();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("B")) {
                    ReleveEditor.this.copyEventDateToIndiBirthDate();
                } else if (actionEvent.getActionCommand().toUpperCase().equals("H")) {
                    ReleveEditor.this.copyEventDateToIndiDeathDate();
                } else if (actionEvent.getActionCommand().toLowerCase().equals("=")) {
                    ReleveEditor.this.copyPreviousRecordField();
                } else if (actionEvent.getActionCommand().toLowerCase().equals("+")) {
                    ReleveEditor.this.copyPreviousRecordField();
                }
            }
        });
    }

    public void initModel(DataManager dataManager, MainPanelInterface transcriber) {
        if (dataManager != null) {
            this.dataManager = dataManager;
            this.recordModel = dataManager.getDataModel();
            this.transcriber = transcriber;
            EditorConfigGroupDialog.addEditorConfigListener(this);
        }
    }

    public void componentClosed() {
        EditorConfigGroupDialog.removeEditorConfigListener(this);
    }

    private void giveFocusToIndiAge() {
        Bean indiAge = this.getBean(AbstractRecord.FieldType.indiAge);
        if (indiAge != null) {
            indiAge.requestFocusInWindow();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void copyIndiNameToIndiFatherName() {
        Bean indiLastNameBean = this.getBean(AbstractRecord.FieldType.indiLastName);
        Bean indiFatherLastNameBean = this.getBean(AbstractRecord.FieldType.indiFatherLastName);
        if (indiLastNameBean != null && indiFatherLastNameBean != null) {
            this.commitCurrentFocusedBean();
            indiFatherLastNameBean.replaceValue(indiFatherLastNameBean.getRecord().getField(indiLastNameBean.getFieldType()));
            indiFatherLastNameBean.requestFocusInWindow();
            this.commitCurrentFocusedBean();
            Bean indiFatherFirstNameBean = this.getBean(AbstractRecord.FieldType.indiFatherFirstName);
            if (indiFatherFirstNameBean != null) {
                indiFatherFirstNameBean.requestFocusInWindow();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void copyWifeNameToWifeFatherName() {
        Bean wifeLastNameBean = this.getBean(AbstractRecord.FieldType.wifeLastName);
        Bean wifeFatherLastNameBean = this.getBean(AbstractRecord.FieldType.wifeFatherLastName);
        if (wifeLastNameBean != null && wifeFatherLastNameBean != null) {
            this.commitCurrentFocusedBean();
            wifeFatherLastNameBean.replaceValue(wifeLastNameBean.getField());
            wifeFatherLastNameBean.requestFocusInWindow();
            this.commitCurrentFocusedBean();
            Bean wifeFatherFirstNameBean = this.getBean(AbstractRecord.FieldType.wifeFatherFirstName);
            if (wifeFatherFirstNameBean != null) {
                wifeFatherFirstNameBean.requestFocusInWindow();
            } else {
                wifeFatherLastNameBean.requestFocusInWindow();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void copyEventDateToIndiBirthDate() {
        Bean eventDateBean = this.getBean(AbstractRecord.FieldType.eventDate);
        Bean indiBirthDateBean = this.getBean(AbstractRecord.FieldType.indiBirthDate);
        if (eventDateBean != null && indiBirthDateBean != null) {
            this.commitCurrentFocusedBean();
            indiBirthDateBean.replaceValue(eventDateBean.getRecord().getField(eventDateBean.getFieldType()));
            indiBirthDateBean.requestFocusInWindow();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void copyEventDateToIndiDeathDate() {
        Bean eventDateBean = this.getBean(AbstractRecord.FieldType.eventDate);
        Bean indiDeathDateBean = this.getBean(AbstractRecord.FieldType.indiDeathDate);
        if (eventDateBean != null && indiDeathDateBean != null) {
            this.commitCurrentFocusedBean();
            indiDeathDateBean.replaceValue(eventDateBean.getRecord().getField(eventDateBean.getFieldType()));
            indiDeathDateBean.requestFocusInWindow();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void copyPreviousRecordField() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focused == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        AbstractRecord previousRecord = this.dataManager.getDataModel().getRecord(this.dataManager.getPreviousRecordIndex());
        if (previousRecord == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Field previousField = previousRecord.getField(this.currentFocusedBean.getFieldType());
        this.currentFocusedBean.replaceValue(previousField);
    }

    public void selectRecord(int recordIndex) {
        this.selectRecord(this.recordModel.getRecord(recordIndex));
    }

    private void selectRecord(AbstractRecord record) {
        this.currentRecord = record;
        this.currentFocusedBean = null;
        this.fieldsPanel.setVisible(false);
        this.fieldsPanel.setFocusTraversalPolicyProvider(true);
        this.fieldsPanel.setFocusCycleRoot(true);
        this.fieldsPanel.resetKeyboardActions();
        for (KeyStroke keyStroke : this.recordKeyStrokeList) {
            this.getInputMap(2).remove(keyStroke);
            this.getActionMap().remove(keyStroke.toString());
        }
        this.recordKeyStrokeList.clear();
        this.fieldsPanel.removeAll();
        this.jLabelPlace.setText(RecordInfoPlace.EMPTY);
        this.jButtonPlace.setEnabled(this.currentRecord != null);
        if (this.recordModel != null) {
            int lineNo = 0;
            if (record != null) {
                this.jLabelPlace.setText(record.getPlace().getValue());
                for (BeanGroup group : BeanGroup.getGroups(record.getType())) {
                    if (!group.isVisible()) continue;
                    KeyStroke[] keyStrokes = EditorBeanGroup.getGroupKeystrokes(group.getId());
                    this.addRow(lineNo, group.getTitle(), keyStrokes, record.getType(), group);
                    ++lineNo;
                    for (BeanField editorBeanField : group.getFields()) {
                        if (!editorBeanField.isVisible()) continue;
                        Object label = editorBeanField.getLabel();
                        Bean bean = switch (editorBeanField.getFieldType()) {
                            case AbstractRecord.FieldType.eventTag -> new BeanEventTag();
                            case AbstractRecord.FieldType.eventType -> new BeanEventType(this.dataManager.getCompletionProvider().getEventTypes());
                            case AbstractRecord.FieldType.indiBirthDate -> {
                                label = ((String)label).substring(0, 5) + ". (Alt-B)";
                                yield new BeanDate();
                            }
                            case AbstractRecord.FieldType.indiDeathDate -> {
                                label = ((String)label).substring(0, 5) + ". (Alt-H)";
                                yield new BeanDate();
                            }
                            case AbstractRecord.FieldType.eventDate, AbstractRecord.FieldType.secondDate, AbstractRecord.FieldType.wifeBirthDate -> new BeanDate();
                            case AbstractRecord.FieldType.indiLastName, AbstractRecord.FieldType.indiMarriedLastName, AbstractRecord.FieldType.indiMotherLastName, AbstractRecord.FieldType.wifeLastName, AbstractRecord.FieldType.wifeMarriedLastName, AbstractRecord.FieldType.wifeMotherLastName, AbstractRecord.FieldType.witness1LastName, AbstractRecord.FieldType.witness2LastName, AbstractRecord.FieldType.witness3LastName, AbstractRecord.FieldType.witness4LastName -> new BeanLastName(this.dataManager.getCompletionProvider().getLastNames());
                            case AbstractRecord.FieldType.indiFatherLastName -> {
                                label = (String)label + " (Alt-X)";
                                yield new BeanLastName(this.dataManager.getCompletionProvider().getLastNames());
                            }
                            case AbstractRecord.FieldType.wifeFatherLastName -> {
                                label = (String)label + " (Alt-Y)";
                                yield new BeanLastName(this.dataManager.getCompletionProvider().getLastNames());
                            }
                            case AbstractRecord.FieldType.indiFirstName, AbstractRecord.FieldType.indiMarriedFirstName, AbstractRecord.FieldType.indiFatherFirstName, AbstractRecord.FieldType.indiMotherFirstName, AbstractRecord.FieldType.wifeFirstName, AbstractRecord.FieldType.wifeMarriedFirstName, AbstractRecord.FieldType.wifeFatherFirstName, AbstractRecord.FieldType.wifeMotherFirstName, AbstractRecord.FieldType.witness1FirstName, AbstractRecord.FieldType.witness2FirstName, AbstractRecord.FieldType.witness3FirstName, AbstractRecord.FieldType.witness4FirstName -> new BeanFirstName(this.dataManager.getCompletionProvider().getFirstNames());
                            case AbstractRecord.FieldType.indiSex, AbstractRecord.FieldType.wifeSex -> new BeanSex();
                            case AbstractRecord.FieldType.indiAge -> {
                                label = (String)label + " (Alt-A)";
                                yield new BeanAge();
                            }
                            case AbstractRecord.FieldType.indiFatherAge, AbstractRecord.FieldType.indiMotherAge, AbstractRecord.FieldType.wifeAge, AbstractRecord.FieldType.wifeFatherAge, AbstractRecord.FieldType.wifeMotherAge -> new BeanAge();
                            case AbstractRecord.FieldType.indiMarriedDead, AbstractRecord.FieldType.indiFatherDead, AbstractRecord.FieldType.indiMotherDead, AbstractRecord.FieldType.wifeMarriedDead, AbstractRecord.FieldType.wifeFatherDead, AbstractRecord.FieldType.wifeMotherDead -> new BeanDead();
                            case AbstractRecord.FieldType.indiOccupation, AbstractRecord.FieldType.indiMarriedOccupation, AbstractRecord.FieldType.indiFatherOccupation, AbstractRecord.FieldType.indiMotherOccupation, AbstractRecord.FieldType.wifeOccupation, AbstractRecord.FieldType.wifeMarriedOccupation, AbstractRecord.FieldType.wifeFatherOccupation, AbstractRecord.FieldType.wifeMotherOccupation, AbstractRecord.FieldType.witness1Occupation, AbstractRecord.FieldType.witness2Occupation, AbstractRecord.FieldType.witness3Occupation, AbstractRecord.FieldType.witness4Occupation -> new BeanOccupation(this.dataManager.getCompletionProvider().getOccupations());
                            case AbstractRecord.FieldType.indiBirthPlace, AbstractRecord.FieldType.indiDeathPlace, AbstractRecord.FieldType.wifeBirthPlace, AbstractRecord.FieldType.indiResidence, AbstractRecord.FieldType.indiMarriedResidence, AbstractRecord.FieldType.indiFatherResidence, AbstractRecord.FieldType.indiMotherResidence, AbstractRecord.FieldType.wifeResidence, AbstractRecord.FieldType.wifeMarriedResidence, AbstractRecord.FieldType.wifeFatherResidence, AbstractRecord.FieldType.wifeMotherResidence -> new BeanPlace(this.dataManager.getCompletionProvider().getPlaces());
                            case AbstractRecord.FieldType.freeComment -> new BeanFreeComment();
                            case AbstractRecord.FieldType.notary -> new BeanNotary(this.dataManager.getCompletionProvider().getNotaries());
                            case AbstractRecord.FieldType.indiComment, AbstractRecord.FieldType.indiMarriedComment, AbstractRecord.FieldType.indiFatherComment, AbstractRecord.FieldType.indiMotherComment, AbstractRecord.FieldType.wifeComment, AbstractRecord.FieldType.wifeMarriedComment, AbstractRecord.FieldType.wifeFatherComment, AbstractRecord.FieldType.wifeMotherComment, AbstractRecord.FieldType.witness1Comment, AbstractRecord.FieldType.witness2Comment, AbstractRecord.FieldType.witness3Comment, AbstractRecord.FieldType.witness4Comment, AbstractRecord.FieldType.cote, AbstractRecord.FieldType.parish -> new BeanSimpleValue();
                            case AbstractRecord.FieldType.generalComment, AbstractRecord.FieldType.deedText -> new BeanText();
                            case AbstractRecord.FieldType.eventMedia -> new BeanMedia(this.transcriber);
                            default -> new BeanSimpleValue();
                        };
                        this.addRow(lineNo, (String)label, bean, keyStrokes);
                        bean.setContext(record, editorBeanField.getFieldType());
                        bean.setName(editorBeanField.getFieldType().name());
                        keyStrokes = null;
                        ++lineNo;
                    }
                }
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = lineNo;
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weighty = 1.0;
            JLabel jLabelEnd = new JLabel();
            this.fieldsPanel.add((Component)jLabelEnd, gridBagConstraints);
        }
        this.fieldsPanel.revalidate();
        this.fieldsPanel.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReleveEditor.this.jScrollPane1.getViewport().setViewPosition(new Point(0, 0));
            }
        });
    }

    private void addRow(int lineNo, String label, final Bean bean, KeyStroke[] keyStrokes) {
        JLabel jLabel1 = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = lineNo;
        gridBagConstraints.anchor = 17;
        jLabel1.setText(label);
        this.fieldsPanel.add((Component)jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = lineNo;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.fieldsPanel.add((Component)bean, gridBagConstraints);
        this.addLastFocusListeners(bean);
        if (keyStrokes != null) {
            for (KeyStroke keyStroke : keyStrokes) {
                this.getInputMap(2).put(keyStroke, lineNo);
                this.recordKeyStrokeList.add(keyStroke);
            }
            this.getActionMap().put(lineNo, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    bean.requestFocusInWindow();
                }
            });
        }
    }

    private void addRow(int lineNo, String label, KeyStroke[] keyStrokes, final AbstractRecord.RecordType recordType, final BeanGroup group) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = lineNo;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel1 = new JLabel();
        JPanel jpanel1 = new JPanel();
        jpanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        jpanel1.setLayout(new BorderLayout());
        JButton jbutton1 = new JButton();
        jbutton1.setText("--");
        for (BeanField field : group.getFields()) {
            if (!field.isUsed() || field.isVisible()) continue;
            jbutton1.setText("+");
            break;
        }
        jbutton1.setMargin(new Insets(0, 0, 0, 0));
        jbutton1.setFocusable(false);
        jbutton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                EditorConfigGroupDialog.showEditorConfigGroupDialog(recordType, group, evt);
            }
        });
        jLabel1.setHorizontalAlignment(0);
        if (keyStrokes == null) {
            jLabel1.setText(label);
        } else {
            jLabel1.setText(label + "   ( Alt-" + String.valueOf((char)keyStrokes[0].getKeyCode()) + " )");
        }
        jpanel1.add((Component)jbutton1, "West");
        jpanel1.add((Component)jLabel1, "Center");
        this.fieldsPanel.add((Component)jpanel1, gridBagConstraints);
    }

    @Override
    public void onEditorConfigChanged(AbstractRecord.RecordType recordType) {
        if (this.currentRecord != null && this.currentRecord.getType() == recordType) {
            this.commitCurrentFocusedBean();
            this.selectRecord(this.currentRecord);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Container parent;
        final JComponent focused = (JComponent)focusEvent.getSource();
        for (parent = focused.getParent(); parent != null && !(parent instanceof Bean); parent = parent.getParent()) {
        }
        this.currentFocusedBean = (Bean)parent;
        focused.setBackground(new Color(200, 255, 255));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle rect = focused.getBounds();
                rect.y -= 20;
                rect.height += 40;
                ((JComponent)focused.getParent()).scrollRectToVisible(rect);
            }
        });
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        JComponent focused = (JComponent)focusEvent.getSource();
        focused.setBackground(new Color(255, 255, 255));
        this.commitCurrentFocusedBean();
    }

    public boolean verifyCurrentRecord(int currentRecordIndex) {
        if (this.currentFocusedBean != null) {
            this.commitCurrentFocusedBean();
            Object errorMessage = this.dataManager.verifyRecord(this.currentFocusedBean.getRecord());
            if (((String)errorMessage).isEmpty()) {
                return true;
            }
            Toolkit.getDefaultToolkit().beep();
            errorMessage = (String)errorMessage + NbBundle.getMessage(ReleveEditor.class, (String)"ReleveEditor.verifyRecord.message");
            int choice = JOptionPane.showConfirmDialog(this, errorMessage, NbBundle.getMessage(ReleveEditor.class, (String)"ReleveEditor.verifyRecord.title"), 0, 0);
            switch (choice) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            return true;
        }
        return true;
    }

    public void commitCurrentFocusedBean() {
        Bean bean = this.currentFocusedBean;
        if (bean != null && bean.hasChanged()) {
            AbstractRecord[] duplicateRecords;
            AbstractRecord record = bean.getRecord();
            AbstractRecord.FieldType fieldType = bean.getFieldType();
            String oldValue = bean.getFieldValue();
            bean.commit();
            String newValue = bean.getFieldValue();
            if (DataManager.getNewValueControlEnabled() && !newValue.isEmpty()) {
                List<String> completionList = null;
                switch (fieldType) {
                    case indiFirstName: 
                    case indiMarriedFirstName: 
                    case indiFatherFirstName: 
                    case indiMotherFirstName: 
                    case wifeFirstName: 
                    case wifeMarriedFirstName: 
                    case wifeFatherFirstName: 
                    case wifeMotherFirstName: 
                    case witness1FirstName: 
                    case witness2FirstName: 
                    case witness3FirstName: 
                    case witness4FirstName: {
                        completionList = this.dataManager.getCompletionProvider().getFirstNames().getIncluded();
                        break;
                    }
                    case indiLastName: 
                    case indiMarriedLastName: 
                    case indiMotherLastName: 
                    case wifeLastName: 
                    case wifeMarriedLastName: 
                    case wifeMotherLastName: 
                    case witness1LastName: 
                    case witness2LastName: 
                    case witness3LastName: 
                    case witness4LastName: 
                    case indiFatherLastName: 
                    case wifeFatherLastName: {
                        completionList = this.dataManager.getCompletionProvider().getLastNames().getIncluded();
                        break;
                    }
                    case indiOccupation: 
                    case indiMarriedOccupation: 
                    case indiFatherOccupation: 
                    case indiMotherOccupation: 
                    case wifeOccupation: 
                    case wifeMarriedOccupation: 
                    case wifeFatherOccupation: 
                    case wifeMotherOccupation: 
                    case witness1Occupation: 
                    case witness2Occupation: 
                    case witness3Occupation: 
                    case witness4Occupation: {
                        completionList = this.dataManager.getCompletionProvider().getOccupations().getIncluded();
                        break;
                    }
                    case eventType: {
                        completionList = this.dataManager.getCompletionProvider().getEventTypes().getIncluded();
                        break;
                    }
                    case notary: {
                        completionList = this.dataManager.getCompletionProvider().getNotaries().getIncluded();
                    }
                }
                if (completionList != null && !completionList.contains(newValue)) {
                    Toolkit.getDefaultToolkit().beep();
                    int choice = JOptionPane.showConfirmDialog(this, String.format(NbBundle.getMessage(ReleveEditor.class, (String)"ReleveEditor.confirmNewValue.question"), BeanField.getLabel(bean.getFieldType()), newValue), NbBundle.getMessage(ReleveEditor.class, (String)"ReleveEditor.confirmNewValue.title"), 0, 3);
                    if (choice == 1 || choice == -1) {
                        bean.setFieldValue(oldValue);
                        bean.refresh();
                        bean.requestFocusInWindow();
                        return;
                    }
                }
            }
            if (this.recordModel != null && !oldValue.equals(bean.getFieldValue())) {
                this.recordModel.notiFyFieldChanged(record, bean.getFieldType(), bean.getField(), oldValue);
            }
            switch (fieldType) {
                case indiFirstName: {
                    if (!record.getFieldValue(AbstractRecord.FieldType.indiFirstName).isEmpty()) {
                        record.setFieldValue(AbstractRecord.FieldType.indiSex, this.dataManager.getCompletionProvider().getFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.indiFirstName)));
                        this.refreshBeanField(AbstractRecord.FieldType.indiSex);
                    }
                    this.dataManager.getCompletionProvider().updateFirstName(bean.getFieldValue(), record.getFieldValue(AbstractRecord.FieldType.indiSex), oldValue, record.getFieldValue(AbstractRecord.FieldType.indiSex));
                    break;
                }
                case indiMarriedFirstName: {
                    this.dataManager.getCompletionProvider().updateFirstName(bean.getFieldValue(), FieldSex.getOppositeString(record.getFieldValue(AbstractRecord.FieldType.indiSex)), oldValue, FieldSex.getOppositeString(record.getFieldValue(AbstractRecord.FieldType.indiSex)));
                    break;
                }
                case indiFatherFirstName: {
                    this.dataManager.getCompletionProvider().updateFirstName(bean.getFieldValue(), "M", oldValue, "M");
                    break;
                }
                case indiMotherFirstName: {
                    this.dataManager.getCompletionProvider().updateFirstName(bean.getFieldValue(), "M", oldValue, "M");
                    break;
                }
                case wifeFirstName: {
                    if (!record.getFieldValue(AbstractRecord.FieldType.wifeFirstName).isEmpty()) {
                        record.setFieldValue(AbstractRecord.FieldType.wifeSex, this.dataManager.getCompletionProvider().getFirstNameSex(record.getFieldValue(AbstractRecord.FieldType.wifeFirstName)));
                        this.refreshBeanField(AbstractRecord.FieldType.wifeSex);
                    }
                    this.dataManager.getCompletionProvider().updateFirstName(bean.getFieldValue(), record.getFieldValue(AbstractRecord.FieldType.wifeSex), oldValue, record.getFieldValue(AbstractRecord.FieldType.wifeSex));
                    break;
                }
                case wifeMarriedFirstName: {
                    this.dataManager.getCompletionProvider().updateFirstName(bean.getFieldValue(), FieldSex.getOppositeString(record.getFieldValue(AbstractRecord.FieldType.wifeSex)), oldValue, FieldSex.getOppositeString(record.getFieldValue(AbstractRecord.FieldType.wifeSex)));
                    break;
                }
                case wifeFatherFirstName: {
                    this.dataManager.getCompletionProvider().updateFirstName(bean.getFieldValue(), "M", oldValue, "M");
                    break;
                }
                case wifeMotherFirstName: {
                    this.dataManager.getCompletionProvider().updateFirstName(bean.getFieldValue(), "F", oldValue, "F");
                    break;
                }
                case witness1FirstName: 
                case witness2FirstName: 
                case witness3FirstName: 
                case witness4FirstName: {
                    this.dataManager.getCompletionProvider().updateFirstName(bean.getFieldValue(), "", oldValue, "");
                    break;
                }
                case indiLastName: 
                case indiMarriedLastName: 
                case indiMotherLastName: 
                case wifeLastName: 
                case wifeMarriedLastName: 
                case wifeMotherLastName: 
                case witness1LastName: 
                case witness2LastName: 
                case witness3LastName: 
                case witness4LastName: 
                case indiFatherLastName: 
                case wifeFatherLastName: {
                    this.dataManager.getCompletionProvider().updateLastName(bean.getFieldValue(), oldValue);
                    break;
                }
                case indiOccupation: 
                case indiMarriedOccupation: 
                case indiFatherOccupation: 
                case indiMotherOccupation: 
                case wifeOccupation: 
                case wifeMarriedOccupation: 
                case wifeFatherOccupation: 
                case wifeMotherOccupation: 
                case witness1Occupation: 
                case witness2Occupation: 
                case witness3Occupation: 
                case witness4Occupation: {
                    this.dataManager.getCompletionProvider().updateOccupation(bean.getFieldValue(), oldValue);
                    break;
                }
                case eventType: {
                    this.dataManager.getCompletionProvider().updateEventType(bean.getFieldValue(), oldValue);
                    break;
                }
                case notary: {
                    this.dataManager.getCompletionProvider().updateNotary(bean.getFieldValue(), oldValue);
                    break;
                }
                case indiBirthPlace: 
                case wifeBirthPlace: 
                case indiResidence: 
                case indiMarriedResidence: 
                case indiFatherResidence: 
                case indiMotherResidence: 
                case wifeResidence: 
                case wifeMarriedResidence: 
                case wifeFatherResidence: 
                case wifeMotherResidence: {
                    this.dataManager.getCompletionProvider().updatePlaces(bean.getFieldValue(), oldValue);
                }
            }
            if ((fieldType.equals((Object)AbstractRecord.FieldType.eventDate) || fieldType.equals((Object)AbstractRecord.FieldType.indiFirstName) || fieldType.equals((Object)AbstractRecord.FieldType.indiLastName)) && (duplicateRecords = this.recordModel.findDuplicateRecord(record)).length > 0) {
                Object message = String.format(NbBundle.getMessage(ReleveEditor.class, (String)"ReleveEditor.duplicateRecord"), new Object[0]);
                message = (String)message + "\n id=";
                for (int index = 0; index < duplicateRecords.length; ++index) {
                    message = (String)message + Integer.toString(this.recordModel.getIndex(record) + 1);
                    if (index >= duplicateRecords.length - 1) continue;
                    message = (String)message + ", ";
                }
                String title = "Informations";
                JOptionPane.showMessageDialog(this, message, title, 1);
            }
        }
    }

    public void addLastFocusListeners(Container container) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            if (component instanceof JTextField || component instanceof JFormattedTextField || component instanceof JComboBox || component instanceof JCheckBox || component instanceof JTextArea) {
                component.addFocusListener(this);
            }
            if (!(component instanceof Container)) continue;
            this.addLastFocusListeners((Container)component);
        }
    }

    public Bean getBean(AbstractRecord.FieldType fieldType) {
        for (Component component : this.fieldsPanel.getComponents()) {
            Bean bean;
            if (!(component instanceof Bean) || (bean = (Bean)component).getFieldType() != fieldType) continue;
            return bean;
        }
        return null;
    }

    public void selectField(AbstractRecord.FieldType fieldType) {
        for (Component component : this.fieldsPanel.getComponents()) {
            Bean bean;
            if (!(component instanceof Bean) || (bean = (Bean)component).getFieldType() != fieldType) continue;
            bean.requestFocusInWindow();
            break;
        }
    }

    public void selectFirstField() {
        for (Component component : this.fieldsPanel.getComponents()) {
            if (!(component instanceof Bean)) continue;
            Bean bean = (Bean)component;
            bean.requestFocusInWindow();
            break;
        }
    }

    public void refreshBeanField(AbstractRecord.FieldType fieldType) {
        for (Component component : this.fieldsPanel.getComponents()) {
            Bean bean;
            if (!(component instanceof Bean) || (bean = (Bean)component).getFieldType() != fieldType) continue;
            bean.refresh();
            break;
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jPanelPlace = new JPanel();
        this.jLabelPlace = new JLabel();
        this.jButtonPlace = new JButton();
        this.fieldsPanel = new JPanel();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanelPlace.setBorder(BorderFactory.createBevelBorder(0));
        this.jPanelPlace.setLayout(new BorderLayout());
        this.jLabelPlace.setHorizontalAlignment(0);
        this.jLabelPlace.setHorizontalTextPosition(0);
        this.jLabelPlace.setName("placeLabel");
        this.jLabelPlace.setOpaque(true);
        this.jPanelPlace.add((Component)this.jLabelPlace, "Center");
        this.jButtonPlace.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Geo.png")));
        this.jButtonPlace.setToolTipText(NbBundle.getMessage(ReleveEditor.class, (String)"ReleveEditor.toolTipText"));
        this.jButtonPlace.setName("");
        this.jButtonPlace.setPreferredSize(new Dimension(29, 25));
        this.jButtonPlace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveEditor.this.jButtonPlaceActionPerformed(evt);
            }
        });
        this.jPanelPlace.add((Component)this.jButtonPlace, "East");
        this.jPanel1.add((Component)this.jPanelPlace, "North");
        this.fieldsPanel.setName("");
        this.fieldsPanel.setLayout(new GridBagLayout());
        this.jPanel1.add((Component)this.fieldsPanel, "Center");
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void jButtonPlaceActionPerformed(ActionEvent evt) {
        RelevePlaceEditor panel = new RelevePlaceEditor(this.dataManager, this.currentRecord, this.currentRecord.getPlace());
        Object o = DialogManager.create((String)NbBundle.getMessage(RelevePlaceEditor.class, (String)"RelevePlaceEditor.Title"), (JComponent)panel).setDialogId(RelevePlaceEditor.class).setMessageType(-1).setOptionType(2).show();
        if (o == DialogManager.OK_OPTION) {
            panel.setDefaultPlace();
            this.updatePlace(panel.getPlace());
        }
    }

    public void updatePlace(RecordInfoPlace place) {
        String oldValue = this.currentRecord.getPlace().getValue();
        this.currentRecord.setPlace(place);
        this.jLabelPlace.setText(place.getValue());
        if (this.recordModel != null) {
            this.recordModel.notiFyFieldChanged(this.currentRecord, AbstractRecord.FieldType.place, this.currentRecord.getField(AbstractRecord.FieldType.place), oldValue);
        }
    }
}

