/*
 * Decompiled with CFR 0.152.
 */
package genj.io.input;

import genj.gedcom.GedcomOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLChecker {
    private static final Logger LOG = Logger.getLogger("ancestris.URLChecker");
    private static int NBSTEPS = 200;
    private URL url;
    private int timeout;
    private boolean error;
    private boolean isEmptyFile;

    public static URLChecker createURLChecker(URL url, String urlText, int timeout) {
        return new URLChecker(url, urlText, timeout);
    }

    public URLChecker(URL url, String urlText, int timeout) {
        int timeoutParam = GedcomOptions.getInstance().getURLTimeout() * 1000;
        this.timeout = timeout < 1 ? timeoutParam : timeout;
        this.error = false;
        this.isEmptyFile = false;
        this.url = url;
        if (this.url == null) {
            try {
                this.url = new URL(urlText);
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.INFO, "(check URL) Malformed URL " + urlText, ex.getLocalizedMessage());
                this.error = true;
            }
        }
        if (this.url.getAuthority() == null || this.url.getAuthority().isEmpty() || this.url.getHost().isEmpty()) {
            this.error = true;
        }
        if (this.url.getFile().isEmpty() || this.url.getFile().equals(File.separator)) {
            this.isEmptyFile = true;
        }
    }

    public boolean isFileEmpty() {
        return this.isEmptyFile;
    }

    public CheckResult run() {
        CheckResult checkResult = new CheckResult();
        if (this.error) {
            return checkResult;
        }
        CheckURLRunnable mainTask = new CheckURLRunnable(this.url, this.timeout);
        Thread thread = new Thread(mainTask);
        thread.start();
        int step = this.timeout / NBSTEPS;
        try {
            for (int i = 0; i < NBSTEPS; ++i) {
                TimeUnit.MILLISECONDS.sleep(step);
                if (!mainTask.isCompleted()) continue;
                checkResult = mainTask.getResult();
                break;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        thread.interrupt();
        return checkResult;
    }

    public class CheckResult {
        private boolean result = false;
        private URL url;
        private InputStream in;
        private String type = null;

        public boolean getResult() {
            return this.result;
        }

        public URL getURL() {
            return this.url;
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public String getType() {
            return this.type;
        }
    }

    private class CheckURLRunnable
    implements Runnable {
        private CheckResult checkResult;
        private int timeout;
        private boolean completed;

        public CheckURLRunnable(URL url, int timeout) {
            this.checkResult = new CheckResult();
            this.completed = false;
            this.checkResult.url = url;
            this.timeout = timeout;
        }

        protected boolean isCompleted() {
            return this.completed;
        }

        protected CheckResult getResult() {
            return this.checkResult;
        }

        @Override
        public void run() {
            HttpURLConnection huc = null;
            try {
                this.completed = false;
                huc = (HttpURLConnection)this.checkResult.url.openConnection();
                huc.setInstanceFollowRedirects(true);
                huc.setConnectTimeout(this.timeout);
                huc.setReadTimeout(this.timeout);
                huc.setRequestMethod("HEAD");
                huc.setRequestProperty("User-Agent", "Ancestris Agent/13.0");
                huc.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7");
                int responseCode = huc.getResponseCode();
                boolean bl = this.checkResult.result = 200 == responseCode;
                if (this.checkResult.result) {
                    this.checkResult.in = this.getInputStream();
                    this.checkResult.type = huc.getContentType();
                }
                if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                    this.checkResult.url = new URL(huc.getHeaderField("Location"));
                    this.checkResult.result = true;
                }
                this.completed = true;
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "(check URL) CheckURLRunnable http connection exception " + this.checkResult.url.toString(), ex.getLocalizedMessage());
            }
            finally {
                if (huc != null) {
                    huc.disconnect();
                }
            }
        }

        private InputStream getInputStream() throws IOException {
            HttpURLConnection conn = (HttpURLConnection)URLChecker.this.url.openConnection();
            conn.setInstanceFollowRedirects(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Ancestris Agent/13.0");
            conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7");
            return conn.getInputStream();
        }
    }
}

