/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.renderer.RenderOptions;
import gj.awt.geom.Dimension2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DPI {
    public static final RenderingHints.Key KEY = new DPIHintKey();
    public static final double INCH = 2.54;
    private int horizontal;
    private int vertical;

    public int horizontal() {
        return this.horizontal;
    }

    public int vertical() {
        return this.vertical;
    }

    public DPI(int horizontal, int vertical) {
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    public static DPI get(Graphics graphics) {
        DPI dpi = (DPI)((Graphics2D)graphics).getRenderingHint(KEY);
        if (dpi == null) {
            dpi = RenderOptions.getInstance().getDPI();
        }
        return dpi;
    }

    public Dimension2D toPixel(Dimension2D inches) {
        return new Dimension2D.Double(inches.getWidth() * (double)this.horizontal, inches.getHeight() * (double)this.vertical);
    }

    public Rectangle2D toPixel(Rectangle2D inches) {
        return new Rectangle2D.Double(inches.getX() * (double)this.horizontal, inches.getY() * (double)this.vertical, inches.getWidth() * (double)this.horizontal, inches.getHeight() * (double)this.vertical);
    }

    public Line2D toPixel(Line2D inches) {
        return new Line2D.Double(this.toPixel(inches.getP1()), this.toPixel(inches.getP2()));
    }

    public Point2D toPixel(Point2D inches) {
        return new Point2D.Double(inches.getX() * (double)this.horizontal, inches.getY() * (double)this.vertical);
    }

    public String toString() {
        return this.horizontal + " by " + this.vertical + " dpi";
    }

    private static class DPIHintKey
    extends RenderingHints.Key {
        private DPIHintKey() {
            super(0);
        }

        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof DPI;
        }
    }
}

