/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util.cumulative;

import java.util.LinkedList;

public class CumulativeSpells {
    LinkedList<Spell> spells = new LinkedList();
    double currentDate = Double.NaN;

    public Spell startSpell(double date) {
        Spell s = new Spell(date);
        this.spells.add(s);
        return s;
    }

    public void updateCurrentSpell(double date) {
        Spell s;
        if (this.spells.size() > 0 && !Double.isNaN(this.currentDate) && !(s = this.spells.getLast()).closed) {
            s.end = this.currentDate;
        }
        this.currentDate = date;
    }

    public Spell closeSpell() {
        Spell s;
        if (this.spells.size() > 0 && !(s = this.spells.getLast()).closed) {
            s.closed = true;
            return s;
        }
        return null;
    }

    public Spell getCurrentSpell() {
        Spell s = this.spells.getLast();
        if (s == null) {
            return null;
        }
        return s.closed ? null : s;
    }

    public Spell getSpell(int i) {
        return this.spells.get(i);
    }

    public int getSpellCount() {
        return this.spells.size();
    }

    public Spell getOrCreateSpell(double date) {
        Spell s = this.getCurrentSpell();
        if (s == null) {
            s = this.startSpell(date);
        }
        return s;
    }

    public boolean isEternal() {
        return this.spells.size() == 1 && !this.spells.get(0).isStarted() && !this.spells.get(0).isEnded();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        int i = 0;
        while (i < this.spells.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.spells.get(i).toString());
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public static class Spell {
        private double start;
        private double end;
        private boolean startOpen;
        private boolean endOpen;
        private boolean closed;
        private Object data;

        public Spell(double start, boolean startOpen, double end, boolean endOpen) {
            this.start = start;
            this.startOpen = startOpen;
            this.end = end;
            this.endOpen = endOpen;
            this.closed = false;
        }

        public Spell(double start, double end) {
            this(start, false, end, false);
        }

        public Spell(double start) {
            this(start, false, start, false);
        }

        public double getStartDate() {
            return this.start;
        }

        public double getEndDate() {
            return this.end;
        }

        public boolean isStartOpen() {
            return this.startOpen;
        }

        public boolean isEndOpen() {
            return this.endOpen;
        }

        public boolean isStarted() {
            return !Double.isNaN(this.start);
        }

        public boolean isEnded() {
            return this.closed;
        }

        public void setStartOpen(boolean open) {
            this.startOpen = open;
        }

        public void setEndOpen(boolean open) {
            this.endOpen = open;
        }

        public Object getAttachedData() {
            return this.data;
        }

        public void setAttachedData(Object data) {
            this.data = data;
        }

        public String toString() {
            String str = "";
            if (this.isStarted()) {
                str = String.valueOf(str) + (this.isStartOpen() ? "]" : "[");
                str = String.valueOf(str) + this.start + "; ";
            } else {
                str = String.valueOf(str) + "[...; ";
            }
            if (this.isEnded()) {
                str = String.valueOf(str) + this.end;
                str = String.valueOf(str) + (this.isEndOpen() ? "[" : "]");
            } else {
                str = String.valueOf(str) + "...]";
            }
            return str;
        }
    }
}

