/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.gedcom.consanguinity.ComputeConsanguinity;
import ancestris.modules.gedcom.consanguinity.ConsanguiniteInfo;
import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.io.File;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.openide.util.NbBundle;

public class WebStatsImplex
extends WebSection {
    private BigDecimal dImplexFactor;
    private final List<GenerationInfo> vecGenerationInfo = new ArrayList<GenerationInfo>();
    private final Set<String> setIndi = new HashSet<String>();
    private final Set<String> setCommonAncestor = new HashSet<String>();
    private final Map<String, Indi> mapImplexCommonIndi = new TreeMap<String, Indi>();
    private double dConsanguinityFactor;
    private final Map<String, ConsanguiniteInfo> mapConsanguinityCommonIndi = new TreeMap<String, ConsanguiniteInfo>();
    private final List<ConsanguiniteInfo> listConsanguinite = new ArrayList<ConsanguiniteInfo>();

    public WebStatsImplex(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_StatsImplex"), "stats", "stats_", this.formatFromSize(this.wh.getNbIndis()), 2, 0);
    }

    @Override
    public void create() {
        if (this.wb.sectionIndividualsDetails != null) {
            this.personPage = this.wb.sectionIndividualsDetails.getPagesMap();
            this.prefixPersonDetailsDir = this.buildLinkShort(this, this.wb.sectionIndividualsDetails);
        }
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        this.exportData(dir);
    }

    private void exportData(File dir) {
        String fileStr = this.sectionPrefix + String.format(this.formatNbrs, 2) + this.sectionSuffix;
        File file = this.wh.getFileForName(dir, fileStr);
        try (PrintWriter out = this.wh.getWriter(file, this.UTF8);){
            if (out == null) {
                return;
            }
            this.printOpenHTML(out, "TXT_StatsImplex", this);
            this.printHomeLink(out, this);
            this.clearStats();
            this.wh.getIndiDeCujus(this.wp.param_decujus);
            this.computeConsanguinityFactor(this.wh.indiDeCujus);
            if (this.dConsanguinityFactor != -1.0) {
                this.computeImplexFactor(this.wh.indiDeCujus);
            }
            this.printHeader(out, this.wh.indiDeCujus);
            this.printImplexStats(out);
            this.printConsanguinityStats(out);
            this.printCloseHTML(out);
            this.wh.log.write(fileStr + this.trs("EXEC_DONE"));
        }
    }

    private void clearStats() {
        this.dImplexFactor = BigDecimal.ZERO;
        this.vecGenerationInfo.clear();
        this.setIndi.clear();
        this.setCommonAncestor.clear();
        this.mapImplexCommonIndi.clear();
        this.dConsanguinityFactor = 0.0;
        this.mapConsanguinityCommonIndi.clear();
    }

    private void printHeader(PrintWriter out, Indi indi) {
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("implex_description")) + "</span></p>");
        out.println("<p class=\"description\">" + this.htmlText(this.trs("implex_info")) + "</p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("implex_root_individual")) + "</span></p>");
        out.println("<p class=\"column1\">");
        out.println(this.wrapEntity((Entity)indi));
        out.println("<br /><br />");
        out.println(this.htmlText(this.trs("implex_implex_factor")) + "&nbsp;" + this.dImplexFactor + "%");
        out.println("<br />");
        out.println(this.htmlText(this.trs("implex_consanguinity_factor")) + "&nbsp;" + String.format("%.9f", this.dConsanguinityFactor));
        out.println("<br /></p>");
    }

    private void printImplexStats(PrintWriter out) {
        out.println("<table border=\"0\" cellspacing=\"0\" cellpadding=\"5\" class=\"column1\"><thead><tr>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_generation")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_possible")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_known")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_known_percent")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_cumul")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_cumul_percent")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_diff")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_diffcumul")) + "</th>");
        out.println("<th>" + this.htmlText(this.trs("implex_header_implex_implex")) + "</th>");
        out.println("</tr></thead>");
        out.println("<tbody>");
        for (GenerationInfo info : this.vecGenerationInfo) {
            out.println("<tr>");
            out.println("<td>" + this.htmlText(info.iLevel) + "</td>");
            out.println("<td>" + this.htmlText(info.iPossibleCount) + "</td>");
            out.println("<td>" + this.htmlText(info.iKnownCount) + "</td>");
            out.println("<td>" + this.htmlText(info.dCoverage) + "</td>");
            out.println("<td>" + this.htmlText(info.iKnownCumul) + "</td>");
            out.println("<td>" + this.htmlText(info.dCoverageCumul) + "</td>");
            out.println("<td>" + this.htmlText(info.iDiffCount) + "</td>");
            out.println("<td>" + this.htmlText(info.iDiffCumul) + "</td>");
            out.println("<td>" + this.htmlText(info.dImplex) + "</td>");
            out.println("</tr>");
        }
        out.println("</tbody></table>");
        out.println("<div class=\"spacer\">&nbsp;</div></div>");
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("implex_header_implex_common_ancestors")) + "</span></p>");
        out.println("<p class=\"column1\">");
        for (Indi indi : this.mapImplexCommonIndi.values()) {
            out.println(this.wrapEntity((Entity)indi));
            out.println("<br />");
        }
        out.println("</p>");
        out.println("<div class=\"spacer\">&nbsp;</div>");
        out.println("</div>");
    }

    private void printConsanguinityStats(PrintWriter out) {
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("implex_header_consanguinity_common_ancestors")) + "</span></p>");
        for (ConsanguiniteInfo info : this.mapConsanguinityCommonIndi.values()) {
            out.println("<span class=\"column1f\">");
            out.println(this.wrapEntity((Entity)info.getIndi()));
            out.println("</span>");
            out.println("<p class=\"spacer\">&nbsp;</p>");
        }
        out.println("</div>");
        out.println("<div class=\"contreport\">");
        out.println("<p class=\"decal\"><br /><span class=\"gras\">" + this.htmlText(this.trs("implex_header_consanguinity")) + "</span></p>");
        Collections.sort(this.listConsanguinite, (o1, o2) -> Double.compare(o1.getCoefficient(), o2.getCoefficient()) * -1);
        for (ConsanguiniteInfo info : this.listConsanguinite) {
            out.println("<span class=\"column1f\">");
            out.println(this.wrapEntity((Entity)info.getIndi()));
            out.println("</span>");
            out.println("<span class=\"column2f\">" + this.htmlText(String.format("%.9f", Float.valueOf(info.getCoefficient()))) + "</span><br />");
            out.println("<p class=\"spacer\">&nbsp;</p>");
        }
        out.println("</div>");
    }

    private void computeImplexFactor(Indi indi) {
        ArrayList<Indi> listIndi = new ArrayList<Indi>();
        listIndi.add(indi);
        int iLevel = 1;
        while (!listIndi.isEmpty()) {
            ArrayList<Indi> listParent = new ArrayList<Indi>();
            this.computeGeneration(iLevel, listIndi, listParent);
            listIndi = listParent;
            ++iLevel;
        }
        BigInteger iPossibleCumul = BigInteger.ZERO;
        int iKnownCumul = 0;
        int iDiffCumul = 0;
        for (GenerationInfo info : this.vecGenerationInfo) {
            info.iPossibleCount = BigInteger.ONE.shiftLeft(info.iLevel - 1);
            iPossibleCumul = iPossibleCumul.add(info.iPossibleCount);
            info.iPossibleCumul = iPossibleCumul;
            info.iKnownCumul = iKnownCumul += info.iKnownCount;
            info.iDiffCumul = iDiffCumul += info.iDiffCount;
            BigInteger dC = BigInteger.valueOf(10000 * info.iKnownCount);
            info.dCoverage = (double)dC.divide(info.iPossibleCount).longValue() / 100.0;
            dC = BigInteger.valueOf(10000 * info.iKnownCumul);
            info.dCoverageCumul = (double)dC.divide(info.iPossibleCumul).longValue() / 100.0;
            if (iKnownCumul == 0) continue;
            info.dImplex = BigDecimal.valueOf(info.iKnownCumul - info.iDiffCumul);
            info.dImplex = info.dImplex.multiply(BigDecimal.valueOf(100L));
            this.dImplexFactor = info.dImplex = info.dImplex.divide(BigDecimal.valueOf(info.iKnownCumul), 2, RoundingMode.HALF_DOWN);
        }
    }

    private void addCommonAncestor(Indi indi) {
        if (indi == null) {
            return;
        }
        String strId = indi.getId();
        if (this.setCommonAncestor.contains(strId)) {
            return;
        }
        this.setCommonAncestor.add(strId);
        Fam famc = indi.getFamilyWhereBiologicalChild();
        if (famc != null) {
            this.addCommonAncestor(famc.getWife());
            this.addCommonAncestor(famc.getHusband());
        }
    }

    private void computeGeneration(int iLevel, List<Indi> listIndi, List<Indi> listParent) {
        GenerationInfo info = new GenerationInfo(iLevel);
        this.vecGenerationInfo.add(info);
        for (Indi indi : listIndi) {
            Indi indiHusband;
            String strId = indi.getId();
            if (this.setIndi.contains(strId)) {
                if (!this.setCommonAncestor.contains(strId)) {
                    this.mapImplexCommonIndi.put(strId, indi);
                    this.addCommonAncestor(indi);
                }
            } else {
                this.setIndi.add(strId);
                ++info.iDiffCount;
            }
            ++info.iKnownCount;
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc == null) continue;
            Indi indiWife = famc.getWife();
            if (indiWife != null) {
                listParent.add(indiWife);
            }
            if ((indiHusband = famc.getHusband()) == null) continue;
            listParent.add(indiHusband);
        }
    }

    private void computeConsanguinityFactor(Indi indi) {
        this.dConsanguinityFactor = 0.0;
        ComputeConsanguinity calculation = new ComputeConsanguinity(indi);
        this.dConsanguinityFactor = calculation.compute();
        if (this.dConsanguinityFactor != -1.0) {
            for (ConsanguiniteInfo c : calculation.getCommonAncestors()) {
                this.mapConsanguinityCommonIndi.put(c.getId(), c);
            }
        } else {
            this.wh.log.write(NbBundle.getMessage(WebBook.class, (String)"LOOP_ERROR", (Object)((ConsanguiniteInfo)calculation.getPotentialLoop().get()).getIndi()));
        }
        this.listConsanguinite.addAll(calculation.getCoefficientNotNul());
    }

    private class GenerationInfo {
        int iLevel;
        BigInteger iPossibleCount;
        BigInteger iPossibleCumul;
        int iKnownCount;
        int iKnownCumul;
        int iDiffCount;
        int iDiffCumul;
        double dCoverage;
        double dCoverageCumul;
        BigDecimal dImplex;

        GenerationInfo(int iLevel) {
            this.iLevel = iLevel;
        }
    }
}

