/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.util;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.oxbow.swingbits.util.DeepCopyException;
import org.oxbow.swingbits.util.copy.FastByteArrayInputStream;
import org.oxbow.swingbits.util.copy.FastByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepCopy {
    public static final <T extends Serializable> T copy(T t) {
        return DeepCopy.restore((FastByteArrayInputStream)DeepCopy.store(t).getInputStream());
    }

    public static final <T extends Serializable> FastByteArrayOutputStream store(T t) {
        try {
            FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fastByteArrayOutputStream);
            objectOutputStream.writeObject(t);
            objectOutputStream.flush();
            objectOutputStream.close();
            return fastByteArrayOutputStream;
        }
        catch (Throwable throwable) {
            throw new DeepCopyException("An " + t.getClass().getSimpleName() + " cannot be serialized. The reason: " + throwable.getLocalizedMessage(), throwable);
        }
    }

    public static final <T extends Serializable> T restore(FastByteArrayInputStream fastByteArrayInputStream) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(fastByteArrayInputStream);
            return (T)((Serializable)objectInputStream.readObject());
        }
        catch (Throwable throwable) {
            throw new DeepCopyException("An object cannot be deserizalized. The reason: " + throwable.getLocalizedMessage(), throwable);
        }
    }
}

