/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import ancestris.gedcom.GedcomDirectory;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.option.Option;
import genj.option.PropertyOption;
import genj.report.MyReportAction;
import genj.report.MyReportConfigPanel;
import genj.report.Report;
import genj.report.ReportSelectionListener;
import genj.report.ReportView;
import genj.util.Registry;
import genj.view.Images;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class ReportList
extends JScrollPane {
    public static final int VIEW_LIST = 0;
    public static final int VIEW_TREE = 1;
    private Report[] reports;
    private JTree tree = null;
    private int viewType;
    private Report selection = null;
    private final Callback callback = new Callback();
    private ReportSelectionListener selectionListener = null;
    private TreeModel treeModel = null;
    private TreeModel listModel = null;
    private static final Registry registry = Registry.get(ReportList.class);
    private static final String FOLDER_ACTIONS = "Actions/Tools/Reports";
    private static final String FOLDER_MENU = "Menu/Tools/Reports";
    private static final String FOLDER_TOOLBAR = "Toolbars";
    protected static final String ATTR_REPORTNAME = "reportName";
    protected static final String ATTR_REPORTSCOPE = "reportScope";
    protected static final int VAL_SCOPE_CONTEXT = 0;
    protected static final int VAL_SCOPE_GEDCOM = 1;
    protected static final String ATTR_DISPLAYNAME = "actionName";
    protected static final String ATTR_DISPLAYTIP = "actionTip";
    protected static final String ATTR_FIXED_OPTIONS = "fixedOptions";
    protected static final String ATTR_OPTION_PREFIX = "option.";
    private static final int DEFAULT_POSITION = 5000;

    public ReportList(Report[] reports, int viewType) {
        this.reports = reports;
        this.viewType = viewType;
        this.tree = new JTree();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(this.callback);
        this.tree.addTreeSelectionListener(this.callback);
        this.tree.addTreeExpansionListener(this.callback);
        this.tree.addMouseListener(this.getMouseListener());
        this.tree.setRootVisible(false);
        this.setViewportView(this.tree);
        this.refreshView();
    }

    public void setViewType(int viewType) {
        this.viewType = viewType;
        this.refreshView();
    }

    public int getViewType() {
        return this.viewType;
    }

    public void setSelection(Report report) {
        this.selection = report;
        if (this.selection == null) {
            this.tree.clearSelection();
        } else {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                TreePath path = this.tree.getPathForRow(i);
                Object v = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                if (v != this.selection) continue;
                this.tree.addSelectionPath(path);
                this.tree.makeVisible(path);
                break;
            }
        }
    }

    public Report getSelection() {
        return this.selection;
    }

    public void setSelectionListener(ReportSelectionListener listener) {
        this.selectionListener = listener;
    }

    public void setReports(Report[] reports) {
        this.reports = reports;
        this.listModel = null;
        this.treeModel = null;
        this.refreshView();
    }

    private MouseListener getMouseListener() {
        MouseAdapter retour = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    super.mousePressed(e);
                }
                if (!ReportList.this.tree.isSelectionEmpty()) {
                    Component vue = ReportList.this.getViewport().getView();
                    while (!(vue instanceof ReportView) && (vue = vue.getParent()) != null && !(vue instanceof ReportView)) {
                    }
                    if (vue instanceof ReportView) {
                        ReportView report = (ReportView)((Object)vue);
                        if (e.getClickCount() == 2) {
                            report.startReport();
                        } else if (e.getClickCount() == 1 && e.getButton() == 3) {
                            ReportList.this.createPopupMenu(e);
                        }
                    }
                }
            }
        };
        return retour;
    }

    private void createPopupMenu(MouseEvent e) {
        JPopupMenu popupMenu = new JPopupMenu();
        FileObject reportsProvidersFolder = FileUtil.getConfigFile((String)FOLDER_ACTIONS);
        String reportName = this.getSelection().getClass().getSimpleName();
        HashSet<String> providerNames = new HashSet<String>();
        ArrayList<FileObject> existingReportProviders = new ArrayList<FileObject>();
        for (FileObject child : reportsProvidersFolder.getChildren()) {
            providerNames.add(child.getName());
            if (!reportName.equals(child.getAttribute(ATTR_REPORTNAME))) continue;
            existingReportProviders.add(child);
        }
        JMenuItem action = new JMenuItem(NbBundle.getMessage(ReportList.class, (String)"action.addtomenu"));
        action.setIcon(this.getSelection().getIcon());
        action.addActionListener(ae -> this.buildAddAction(reportsProvidersFolder, reportName, providerNames));
        popupMenu.add(action);
        if (!existingReportProviders.isEmpty()) {
            popupMenu.addSeparator();
            for (FileObject fo : existingReportProviders) {
                action = new JMenuItem(NbBundle.getMessage(ReportList.class, (String)"action.editaction", (Object)fo.getAttribute(ATTR_DISPLAYNAME)));
                action.setIcon((Icon)Images.imgSettings);
                action.addActionListener(ae -> this.editActionProvider(fo, true));
                popupMenu.add(action);
            }
            popupMenu.addSeparator();
            for (FileObject fo : existingReportProviders) {
                action = new JMenuItem(NbBundle.getMessage(ReportList.class, (String)"action.removefrommenu", (Object)fo.getAttribute(ATTR_DISPLAYNAME)));
                action.setIcon((Icon)Images.imgClean);
                FileObject reportToDelete = fo;
                action.addActionListener(ae -> {
                    try {
                        reportToDelete.delete();
                        this.deleteFromFolder(reportToDelete.getName(), FileUtil.getConfigFile((String)FOLDER_MENU));
                        this.deleteFromFolder(reportToDelete.getName(), FileUtil.getConfigFile((String)FOLDER_TOOLBAR));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                });
                popupMenu.add(action);
            }
        }
        popupMenu.show(this.tree, e.getX(), e.getY());
    }

    private void buildAddAction(FileObject reportsProvidersFolder, String reportName, Set<String> providerNames) {
        boolean modified = false;
        FileObject actionProvider = null;
        try {
            Object name = "ReportActionProvider";
            int i = 0;
            if (providerNames.contains(name)) {
                String prefix = (String)name + "_";
                name = prefix + ++i;
                while (providerNames.contains(name)) {
                    name = prefix + ++i;
                }
            }
            actionProvider = reportsProvidersFolder.createData((String)name, "instance");
            actionProvider.setAttribute("instanceClass", (Object)"genj.report.MyReportAction");
            try {
                Method factoryMethod = MyReportAction.class.getMethod("factory", FileObject.class);
                actionProvider.setAttribute("methodvalue:instanceCreate", (Object)factoryMethod);
                actionProvider.setAttribute(ATTR_REPORTNAME, (Object)reportName);
                modified = this.editActionProvider(actionProvider, false);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)FOLDER_MENU));
            DataObject actionDataObject = DataObject.find((FileObject)actionProvider);
            DataShadow shadow = DataShadow.create((DataFolder)dataFolder, (DataObject)actionDataObject);
            Integer position = this.getMaxPositionInFolder(FOLDER_MENU) + 1;
            shadow.getPrimaryFile().setAttribute("position", (Object)position);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (!modified && actionProvider != null) {
            try {
                actionProvider.delete();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private int getMaxPositionInFolder(String folder) {
        Integer maxPosition = 5001;
        for (FileObject child : FileUtil.getConfigFile((String)folder).getChildren()) {
            Integer position;
            Object positionObject = child.getAttribute("position");
            if (positionObject == null || !(positionObject instanceof Integer) || (position = (Integer)positionObject) <= maxPosition) continue;
            maxPosition = position;
        }
        return maxPosition;
    }

    private boolean editActionProvider(FileObject actionProvider, boolean edit) {
        Report report = this.getSelection();
        MyReportConfigPanel panel = new MyReportConfigPanel(report);
        int scope = 0;
        Gedcom gedcom = GedcomDirectory.getDefault().getDefaultContext().getGedcom();
        if (report.accepts(gedcom) == null) {
            scope = 0;
            panel.setEnabledScope(false);
        } else {
            scope = 1;
        }
        if (!edit) {
            String categoryName = NbBundle.getMessage(this.getClass(), (String)("category." + report.getCategory().getName()));
            try {
                actionProvider.setAttribute(ATTR_DISPLAYNAME, (Object)report.getName());
                actionProvider.setAttribute(ATTR_DISPLAYTIP, (Object)NbBundle.getMessage(this.getClass(), (String)"MyReportAction_tip", (Object)("<b>" + report.getName() + "</b>"), (Object)categoryName));
                actionProvider.setAttribute(ATTR_REPORTSCOPE, (Object)scope);
                actionProvider.setAttribute(ATTR_FIXED_OPTIONS, (Object)false);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
        panel.setDisplayName(actionProvider.getAttribute(ATTR_DISPLAYNAME));
        panel.setDisplayTip(actionProvider.getAttribute(ATTR_DISPLAYTIP));
        panel.setScope(actionProvider.getAttribute(ATTR_REPORTSCOPE));
        panel.setFixedOptions(actionProvider.getAttribute(ATTR_FIXED_OPTIONS));
        Object o = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"MyReportConfigPanel.title"), (JComponent)panel).setDialogId(MyReportConfigPanel.class).setMessageType(3).setOptionType(2).show();
        if (o == DialogManager.OK_OPTION) {
            try {
                actionProvider.setAttribute(ATTR_DISPLAYNAME, (Object)panel.getDisplayName());
                actionProvider.setAttribute(ATTR_DISPLAYTIP, (Object)panel.getDisplayTip());
                actionProvider.setAttribute(ATTR_REPORTSCOPE, (Object)panel.getScope());
                actionProvider.setAttribute(ATTR_FIXED_OPTIONS, (Object)panel.isFixedOption());
                if (panel.isFixedOption()) {
                    for (Option option : report.getOptions()) {
                        if (!(option instanceof PropertyOption)) continue;
                        PropertyOption pOption = (PropertyOption)option;
                        actionProvider.setAttribute(ATTR_OPTION_PREFIX + pOption.getProperty(), pOption.getValue());
                    }
                } else {
                    for (String string : Collections.list(actionProvider.getAttributes())) {
                        if (!string.startsWith(ATTR_OPTION_PREFIX)) continue;
                        actionProvider.setAttribute(string, null);
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
            return true;
        }
        return false;
    }

    private void deleteFromFolder(String name, FileObject folder) {
        for (FileObject child : folder.getChildren()) {
            this.deleteFromFolder(name, child);
        }
        if (folder.getName().equals(name)) {
            try {
                folder.delete();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void refreshView() {
        Report oldSelection = this.getSelection();
        if (this.viewType == 0) {
            if (this.listModel == null) {
                this.listModel = this.createList();
            }
            this.tree.setModel(this.listModel);
        } else {
            if (this.treeModel == null) {
                this.treeModel = this.createTree();
            }
            this.tree.setModel(this.treeModel);
            this.refreshExpanded();
        }
        this.setSelection(oldSelection);
    }

    private void refreshExpanded() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            TreePath path = this.tree.getPathForRow(i);
            Object v = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (!(v instanceof Report.Category)) continue;
            Report.Category category = (Report.Category)v;
            if (registry.get("expanded." + category.getName(), true)) {
                this.tree.expandPath(path);
                continue;
            }
            this.tree.collapsePath(path);
        }
    }

    private TreeModel createList() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode();
        for (Report report : this.reports) {
            top.add(new DefaultMutableTreeNode(report));
        }
        return new DefaultTreeModel(top);
    }

    private TreeModel createTree() {
        TreeMap<String, CategoryList> categories = new TreeMap<String, CategoryList>(Report.Category.getComparator());
        for (Report report : this.reports) {
            String name = report.getCategory().getName();
            CategoryList list = (CategoryList)categories.get(name);
            if (list == null) {
                list = new CategoryList(report.getCategory());
                categories.put(name, list);
            }
            list.add(report);
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode();
        for (Map.Entry value : categories.entrySet()) {
            Report[] reps;
            CategoryList list = (CategoryList)value.getValue();
            DefaultMutableTreeNode cat = new DefaultMutableTreeNode(list.getCategory());
            for (Report rep : reps = list.getReportsInCategory()) {
                cat.add(new DefaultMutableTreeNode(rep));
            }
            top.add(cat);
        }
        return new DefaultTreeModel(top);
    }

    private class Callback
    implements TreeCellRenderer,
    TreeSelectionListener,
    TreeExpansionListener {
        private final DefaultTreeCellRenderer defTreeRenderer = new DefaultTreeCellRenderer();

        private Callback() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int index, boolean hasFocus) {
            this.defTreeRenderer.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, index, hasFocus);
            Object v = ((DefaultMutableTreeNode)value).getUserObject();
            if (v instanceof Report) {
                Report report = (Report)v;
                this.defTreeRenderer.setText(report.getName());
                this.defTreeRenderer.setIcon(report.getIcon());
            } else if (v instanceof Report.Category) {
                Report.Category category = (Report.Category)v;
                this.defTreeRenderer.setText(category.getDisplayName());
                this.defTreeRenderer.setIcon((Icon)category.getImage());
            }
            Font font = this.defTreeRenderer.getFont();
            if (isLeaf) {
                this.defTreeRenderer.setFont(new Font(font.getFamily(), 0, font.getSize()));
            } else {
                this.defTreeRenderer.setFont(new Font(font.getFamily(), 1, font.getSize()));
            }
            return this.defTreeRenderer;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object v;
            ReportList.this.selection = null;
            TreePath path = ReportList.this.tree.getSelectionPath();
            if (path != null && (v = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof Report) {
                Report report;
                ReportList.this.selection = report = (Report)v;
            }
            if (ReportList.this.selectionListener != null) {
                ReportList.this.selectionListener.valueChanged(ReportList.this.selection);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            Object v = ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
            if (v instanceof Report.Category) {
                Report.Category category = (Report.Category)v;
                registry.put("expanded." + category.getName(), Boolean.valueOf(true));
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            Object v = ((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
            if (v instanceof Report.Category) {
                Report.Category category = (Report.Category)v;
                registry.put("expanded." + category.getName(), Boolean.valueOf(false));
            }
        }
    }

    private static class CategoryList {
        private final Report.Category category;
        private final List<Report> reportsInCategory = new ArrayList<Report>();

        public CategoryList(Report.Category category) {
            this.category = category;
        }

        public Report.Category getCategory() {
            return this.category;
        }

        public Report[] getReportsInCategory() {
            Collections.sort(this.reportsInCategory, (o1, o2) -> Integer.compare(o1.getPosition(), o2.getPosition()));
            return (Report[])this.reportsInCategory.toArray(Report[]::new);
        }

        public void add(Report report) {
            this.reportsInCategory.add(report);
        }
    }
}

